

// Timer 0 output compare interrupt service routine
static char timer_down=0;
static char drop_timer_flag=0;

//this method beham parts in partsLoc[]
flash char rnd_table[256] = {
4,173,100,101,85,149,200,67,41,61,8,232,179,221,127,90,223,
172,0,216,233,183,243,122,237,226,6,240,140,174,175,211,157,
19,204,180,44,203,96,181,35,135,208,36,159,39,178,89,112,
215,106,195,75,185,119,114,142,26,20,22,201,177,164,34,197,
48,222,51,130,16,120,199,202,109,13,68,10,137,92,1,189,
246,160,93,150,147,47,154,60,156,217,253,134,205,88,64,184,
129,59,126,110,27,124,54,42,32,66,207,143,115,70,235,91,
99,190,252,72,169,117,46,94,3,187,210,128,83,162,52,82,
77,214,248,37,192,111,186,18,23,196,241,229,148,176,107,7,
79,105,167,250,30,62,144,65,71,97,17,11,24,102,103,238,
230,139,55,163,155,209,254,56,25,95,236,191,213,123,78,152,
228,73,193,14,225,125,69,104,239,220,198,212,165,251,245,166,
161,21,206,247,249,158,98,219,40,170,58,57,151,244,168,188,
86,45,218,133,63,136,81,224,146,118,53,227,87,76,74,131,
132,28,141,33,49,50,194,138,182,121,231,15,116,108,43,234,
145,113,29,38,242,2,5,31,171,80,12,84,153,9 };
unsigned char rnd_index = 0;
unsigned char overflow_t0 = 100;
char rnd(unsigned char min , unsigned char max)
{
	rnd_index++;
    if(min == max)
		return 0;
	return (*(rnd_table+rnd_index)%(max-min)) + min;
}

interrupt [TIM0_COMP] void timer0_comp_isr(void)
{
      static unsigned char ct0, ct1;
  unsigned char i;
  i = key_state ^ ~KEY_PIN;    // key changed ?
  ct0 = ~( ct0 & i );          // reset or count ct0
  ct1 = ct0 ^ (ct1 & i);       // reset or count ct1
  i &= ct0 & ct1;              // count until roll over ?
  key_state ^= i;              // then toggle debounced state
  key_press |= key_state & i;  // 0->1: key press detect
  //if (++random_piece > 6) random_piece = 0;     // For make Random on ttris Game
  
  if (++timer_down > overflow_t0)
  {
   timer_down=0;
   drop_timer_flag = 1;
  }  
    // Call Evry 10ms in 8MHZ CPU
 Play_Tune();
}


void init_timer0(){
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 7.813 kHz
// Mode: CTC top=OCR0
// OC0 output: Disconnected
TCCR0=0x0D;
TCNT0=0x00;
OCR0=0x4E;

TIMSK=0x02;


}